//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ReceiveFileData(int Client, char *FileName)
{
    FILE *TargetHandle = NULL;

    char StatusText[255];

    if( (TargetHandle = fopen(FileName, "wb")) == NULL)
    {
        sprintf(StatusText, "(%d) Failed to open target file: '%s'.", MyServer.ClientID[Client], FileName);
        WriteLog(StatusText);
        glErrorCount++;
        return false;
    }

    sprintf(StatusText, "(%d) Receiving client data. %d bytes.", MyServer.ClientID[Client], CI[Client].FileSize);
    WriteLog(StatusText);

    //-------------------------------------------------------------------------
    int DataBufferLen = 0;
	char DataBuffer[MaxReceiveSize + 1];
    DWORD TotalBytesReceived = 0;

	CI[Client].DataCRC = 0xffffffff;

    MyServer.RawMode[Client] = true;

    while(TotalBytesReceived < CI[Client].FileSize && MyServer.Connected[Client])
    {
        if(MyServer.GetReceiveData(Client, DataBuffer, &DataBufferLen))
        {
            CI[Client].DataCRC = PartialCRC(CI[Client].DataCRC, DataBuffer, DataBufferLen);
            TotalBytesReceived = (TotalBytesReceived + DataBufferLen);
            fwrite(DataBuffer, sizeof(char), DataBufferLen, TargetHandle);
        }
        else Sleep(1);
    }
    //-------------------------------------------------------------------------

    MyServer.RawMode[Client] = false;

    CI[Client].DataCRC = (CI[Client].DataCRC ^ 0xffffffff);

    if(TargetHandle) fclose(TargetHandle);
    TargetHandle = NULL;

    if(TotalBytesReceived == CI[Client].FileSize)
    {
        sprintf(StatusText, "(%d) Received %d bytes. CRC: %x", MyServer.ClientID[Client], TotalBytesReceived, CI[Client].DataCRC);
        WriteLog(StatusText);
    }
    else{
        sprintf(StatusText, "(%d) Received %d of %d bytes. Failure.", MyServer.ClientID[Client], TotalBytesReceived, CI[Client].FileSize);
        WriteLog(StatusText);
        glErrorCount++;
        return false;
    }

    return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

